<?php
/**
 * File containing the eZ Publish view implementation.
 *
 * @copyright Your Name here
 * @license licence details
 * @version 1.0.0
 * @package mynewsletter
 */


$http = eZHTTPTool::instance();
$tpl = eZTemplate::factory(); //this line of code is for ez publish 4.3, replace it with the following line for versions prior to that
// $tpl = templateInit(); //version < 4.3 of eZ Publish should use this line of code instead

if ( $http->hasPostVariable( 'email' ) )
{
    $email = $http->postVariable( 'email' );

    /* fetching all users who wish to receive emails: */
    $attributeFilter  = array( array( 'user/newsletter', '=', 1 ) );
    $params = array( 'AttributeFilter' => $attributeFilter );
    // getting the ID of where the users sit in the cms (limiting the area eZ has to search for the objects):
    $parent_node = eZContentObjectTreeNode::fetchByURLPath( 'users/members' ); //note the lowercase. Use underscores rather than hyphens if spaces are included in the path
    $parent_node_id = $parent_node->NodeID;

    // putting all of the above together into a fetch query:
    $newsletter_users = eZContentObjectTreeNode::subTreeByNodeID( $params,$parent_node_id );

    $mailing_list = array();

    foreach( $newsletter_users as $user )
    {
        $userFields = $user->attribute( 'data_map' );
        $mailing_list[] = $userFields['user_account']->attribute( 'content' )->attribute( 'email' );
    }

    $mailing_list_str = implode( ',' , $mailing_list );

    if ( mail( $mailing_list_str, "Newsletter", $email ) )
    {
        $tpl->setVariable( 'feedback', "The email has been sent to ".count( $mailing_list ) . " users" );
    }
    else
    {
        $tpl->setVariable( 'error', "There was a problem sending the email" );
    }
}

// Process template and set path data:
$Result = array();
$Result['content'] = $tpl->fetch( 'design:newsletter/sendemail.tpl' ); //main tpl file to display the output
$Result['left_menu'] = "design:newsletter/leftmenu.tpl";

$Result['path'] = array( array( 'url'  => 'newsletter/sendemail',
                                'text' => 'Send Email' ) );
?>